set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '2332234',
      27,
      0,
      3,
      1,
      '003303',
      NULL,
      ' 3- 7-1978',
      10.915094,
      NULL,
      1.831217,
      NULL,
      NULL,
      NULL,
      1.563725,
      1.133677,
      0.721138,
      NULL,
      1,
      1.130261,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.555812,
      1.614651,
      1.178792,
      1,
      NULL,
      4.842817,
      1.711117,
      5.120977,
      0.714526,
      0,
      0,
      2.235419,
      1.273057,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0.278063,
      1.436608,
      1.135969,
      1.010444,
      0.341728,
      0.916848,
      0,
      1,
      1.412999,
      3.662147,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.812376,
      0.376774,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      1.890581,
      NULL,
      NULL,
      0.686918,
      NULL,
      NULL,
      1.571083,
      1,
      1.099517,
      0,
      0.857642,
      1,
      1,
      1.002982,
      NULL,
      0.554104,
      0,
      0,
      1,
      0.807549,
      0,
      NULL,
      NULL,
      1.610135,
      1,
      NULL,
      1,
      6,
      NULL,
      0.068691,
      5,
      0,
      9,
      0.121351,
      5.943817,
      8,
      NULL,
      1,
      2,
      2,
      9,
      NULL,
      4,
      7.680416,
      4.951579,
      3,
      6,
      NULL,
      4,
      4,
      9.696716,
      NULL,
      11.159207,
      NULL,
      2.282899,
      0.148226,
      1,
      5,
      1.501811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188587,
      0.239437,
      2,
      1,
      1,
      0,
      1.469004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.668587,
      5.129459,
      NULL,
      0,
      1.046976,
      NULL,
      NULL,
      NULL,
      0.810916,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.980674,
      1,
      NULL,
      3,
      1.134604,
      1,
      1.150838,
      0.303576,
      NULL,
      1.084149,
      1.431294,
      1,
      1.785741,
      1,
      0.586181,
      0.983955,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '00232',
      '',
      NULL,
      0.661905,
      NULL,
      '',
      '',
      0.235876,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


