set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '3100422',
      33,
      4,
      2.254082,
      2,
      '013434',
      2.143733,
      ' 5-22-1998',
      28.657116,
      NULL,
      0,
      NULL,
      14,
      NULL,
      1.507494,
      1,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.772448,
      0.909024,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0.771323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972101,
      0.209816,
      1,
      1,
      0.766621,
      NULL,
      NULL,
      1,
      1.889153,
      1.156729,
      NULL,
      1,
      1,
      0.919694,
      0.802437,
      NULL,
      0.307610,
      1.055656,
      0,
      1.419503,
      0.668412,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.154128,
      NULL,
      NULL,
      0.223651,
      0,
      NULL,
      1.054106,
      1,
      0.725922,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1.416176,
      1.778868,
      NULL,
      0,
      1,
      1.436537,
      NULL,
      NULL,
      1.154866,
      6.226108,
      2.925229,
      0,
      1,
      0.488166,
      0.015007,
      1,
      5.521759,
      0,
      6,
      NULL,
      1.307670,
      4,
      3,
      0.732999,
      NULL,
      0.455753,
      1.537999,
      4,
      NULL,
      0.186831,
      9,
      0.474034,
      8.802450,
      3,
      1.886302,
      0,
      2,
      1.891234,
      0,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1.551648,
      0.221390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.414122,
      1.076313,
      1,
      0.622650,
      1.987076,
      0,
      0.066805,
      NULL,
      NULL,
      NULL,
      1,
      1.086738,
      1.661344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747656,
      0.092670,
      0,
      1,
      NULL,
      NULL,
      0,
      0.960429,
      0.846480,
      1.574609,
      NULL,
      1.949331,
      0,
      0.211044,
      1.699898,
      1,
      0,
      1,
      0.480366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '33111',
      '',
      NULL,
      0.400405,
      '',
      NULL,
      '',
      0.187926,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


