set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '3400434',
      67,
      1,
      2,
      3,
      '444442',
      0.726472,
      NULL,
      NULL,
      NULL,
      0.366974,
      NULL,
      1.517581,
      2.193050,
      1.702584,
      0,
      1.955104,
      1,
      1,
      0.184444,
      0,
      1.676075,
      0,
      1,
      0.691431,
      1.424615,
      0.115990,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1.791997,
      3.074637,
      NULL,
      3,
      0,
      3,
      0.200956,
      NULL,
      NULL,
      1.922437,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.460022,
      0,
      1.684515,
      NULL,
      1,
      1.523211,
      3.758203,
      2.949596,
      NULL,
      NULL,
      NULL,
      2,
      2.377724,
      2.241406,
      1.937643,
      1.250797,
      0,
      1.980918,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.579951,
      0.134686,
      NULL,
      0.425200,
      0.881542,
      0.835225,
      NULL,
      1,
      0.917557,
      0,
      0,
      1,
      1.021363,
      1,
      1.481913,
      0.923970,
      0,
      NULL,
      1.719310,
      NULL,
      0.508723,
      1,
      0,
      0,
      0.659407,
      0,
      4.060088,
      4,
      NULL,
      5.807205,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.489235,
      NULL,
      3,
      3.966643,
      7,
      3.334616,
      4,
      5.448189,
      5.065130,
      7.073050,
      1.802365,
      0.841585,
      1.785181,
      1.227973,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146001,
      NULL,
      NULL,
      0.953019,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.915260,
      NULL,
      0,
      3.833103,
      3,
      0.083535,
      1.567740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.817254,
      4.337880,
      6.025289,
      1.284961,
      1,
      1.271867,
      NULL,
      NULL,
      NULL,
      1,
      2.016217,
      1.369595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.379195,
      1.574599,
      3,
      1.779894,
      2,
      0.572224,
      1.247912,
      3,
      NULL,
      0.267411,
      0.203096,
      NULL,
      1.890729,
      0,
      1,
      NULL,
      0.257678,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.709174,
      '01330',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.853543,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


