set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '1334402',
      NULL,
      4,
      1,
      2,
      '413034',
      1.361164,
      ' 6-29-1987',
      12,
      NULL,
      0,
      NULL,
      15,
      0.166189,
      0,
      0.192351,
      1,
      0.528405,
      1,
      1.377078,
      0,
      1,
      0.578277,
      0,
      NULL,
      NULL,
      1,
      1,
      1.103510,
      1.385743,
      0,
      0.646549,
      1,
      0.071173,
      1.666345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756472,
      1,
      1,
      0.382204,
      1.531033,
      1.688080,
      0.875958,
      1,
      0,
      0,
      NULL,
      0.414622,
      1,
      0,
      NULL,
      1.065052,
      0.593084,
      0.165009,
      1,
      1.253317,
      1,
      6.693779,
      0,
      1,
      NULL,
      0.723246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689408,
      0.413280,
      0,
      0.163797,
      NULL,
      1,
      NULL,
      0.346418,
      0,
      0,
      0.995215,
      NULL,
      0,
      NULL,
      0,
      1.684603,
      NULL,
      NULL,
      1.328907,
      NULL,
      1.119278,
      3,
      NULL,
      0.975157,
      0.936416,
      1.989351,
      NULL,
      1,
      4.161862,
      0,
      6.191431,
      6.731718,
      1.842129,
      1,
      1.000071,
      1.001078,
      1.256440,
      5,
      2.342684,
      NULL,
      2.530432,
      0,
      6,
      3,
      8.200226,
      1,
      19.203718,
      0,
      3.361781,
      0.993499,
      0,
      7.167717,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428211,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0.462536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453687,
      3,
      0,
      NULL,
      NULL,
      NULL,
      5.888673,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.805799,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120672,
      1.661868,
      0,
      0.567816,
      2.876188,
      NULL,
      1,
      2,
      0.340896,
      2,
      NULL,
      1,
      1.773235,
      0,
      1,
      0.067030,
      1.224654,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '30311',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


