set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '3312300',
      55.166212,
      NULL,
      NULL,
      2,
      '402440',
      0,
      '11-26-1979',
      12.615216,
      NULL,
      1,
      NULL,
      17.396132,
      2,
      0.442118,
      NULL,
      NULL,
      0.024229,
      0,
      NULL,
      NULL,
      0.217542,
      0,
      NULL,
      NULL,
      NULL,
      1.676341,
      1,
      1.413129,
      1.385654,
      1,
      0,
      5,
      1,
      7,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.786192,
      1,
      3.554710,
      0.688824,
      NULL,
      1.711273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.410599,
      2,
      0,
      2,
      0.379164,
      0.639431,
      1,
      NULL,
      7.936687,
      1,
      0,
      1.472602,
      0,
      NULL,
      NULL,
      1.682399,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1.639532,
      1.120500,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1.348329,
      0,
      0,
      0.164495,
      0,
      NULL,
      0,
      2.854222,
      0,
      1,
      3.848891,
      NULL,
      6.832197,
      1.378938,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      0.331430,
      2,
      1.923189,
      1.116924,
      0,
      7.937791,
      NULL,
      6.509564,
      7,
      6,
      NULL,
      1.496473,
      6.975004,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.377803,
      1.429557,
      0.283980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467235,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630295,
      0,
      1,
      NULL,
      3.134843,
      3,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      5.307530,
      1.334887,
      6.130997,
      7.904486,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.524126,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057271,
      1.647101,
      1.179396,
      NULL,
      0,
      0.631269,
      2,
      0.531412,
      2.799380,
      1,
      1.409099,
      0,
      1,
      0.754955,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '22321',
      '',
      '',
      1.351375,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


