set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '3333440',
      22,
      0,
      3,
      0,
      '004043',
      1.816803,
      ' 3-10-1978',
      24,
      NULL,
      0,
      NULL,
      12.710468,
      0.500827,
      0.750649,
      0,
      0,
      3,
      0.368688,
      NULL,
      0,
      0.292691,
      3.939795,
      NULL,
      1.346492,
      NULL,
      0.849373,
      0.734872,
      3,
      0,
      6.811951,
      3,
      4,
      NULL,
      1.268539,
      1,
      NULL,
      0,
      0.132215,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      1,
      0,
      1,
      1.592493,
      3.004261,
      NULL,
      1.413622,
      NULL,
      3.371291,
      3.341130,
      0,
      0.157004,
      1,
      2.964662,
      0.049838,
      1,
      NULL,
      0.026373,
      1,
      0,
      4.041256,
      NULL,
      1,
      0.946723,
      1.279526,
      NULL,
      NULL,
      0.620225,
      NULL,
      NULL,
      0.716858,
      0.464460,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.886157,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.109853,
      4,
      1.012546,
      1.321979,
      1,
      NULL,
      5.536910,
      0.100029,
      4,
      2.260493,
      9.944415,
      5.057717,
      1,
      4,
      NULL,
      0.251476,
      4,
      1,
      4.684708,
      1.400179,
      1,
      5.147491,
      6.717757,
      7.073163,
      6.897832,
      5,
      3,
      4,
      2,
      1.434088,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.950946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.942682,
      2,
      1.712907,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      7.621100,
      0,
      1,
      0.281214,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852378,
      NULL,
      1,
      3.874914,
      3,
      0,
      1,
      1.739958,
      2.941648,
      NULL,
      0.443670,
      1.291464,
      NULL,
      0,
      0,
      0,
      1,
      0.840429,
      1.752863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '02114',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.904115,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


