set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '4422320',
      30,
      NULL,
      2.419744,
      0,
      '241323',
      1,
      NULL,
      52,
      NULL,
      0,
      NULL,
      19.570546,
      0.728949,
      2.069278,
      0.723602,
      NULL,
      2.758174,
      1.820009,
      1,
      0,
      0.120299,
      3,
      0.288395,
      0.287017,
      1,
      1.945180,
      NULL,
      0,
      0.797128,
      NULL,
      0.367948,
      NULL,
      0,
      NULL,
      0,
      4.909769,
      0.426588,
      NULL,
      1.468361,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      1.693041,
      1,
      0,
      1.504892,
      NULL,
      NULL,
      0.102317,
      3,
      NULL,
      1,
      1,
      0.310681,
      NULL,
      3,
      0.497899,
      1.222844,
      NULL,
      NULL,
      2.980429,
      NULL,
      3.044495,
      1,
      1,
      2.467750,
      0,
      NULL,
      NULL,
      0.191687,
      NULL,
      NULL,
      NULL,
      0,
      0.720673,
      1.429160,
      1.873761,
      0.003487,
      1.665668,
      1,
      0.720148,
      1.515832,
      1.829022,
      0.610532,
      1.675435,
      0.688900,
      1.588485,
      0,
      0.700685,
      0,
      1,
      NULL,
      1,
      5,
      0.460590,
      0.294504,
      1,
      0,
      NULL,
      0.922575,
      2,
      0.008424,
      5,
      1.535019,
      5,
      5.279312,
      0.536325,
      0,
      3,
      0.592459,
      5.522016,
      2.471342,
      1,
      0,
      7,
      3,
      3.679329,
      0.134699,
      5,
      3,
      1.080183,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.386310,
      NULL,
      1.876928,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966701,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.486212,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123719,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.264347,
      0.855516,
      0,
      NULL,
      0.689000,
      1,
      1.739822,
      0,
      0.903122,
      1.153509,
      NULL,
      0,
      1,
      0.301735,
      0.508639,
      0.186304,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40412',
      '',
      '',
      0.499666,
      '',
      '',
      '',
      0.419633,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


