set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '2312414',
      79,
      3,
      1,
      3,
      '221231',
      3,
      NULL,
      8,
      NULL,
      0.115978,
      NULL,
      NULL,
      3.242908,
      0,
      0.836356,
      1,
      1,
      0,
      1,
      2.601039,
      0.401660,
      1.103109,
      0,
      1.994974,
      NULL,
      0.712982,
      1,
      0.807758,
      1.342468,
      NULL,
      1.707180,
      0,
      4,
      5,
      0,
      4.470150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.796369,
      1,
      NULL,
      1.052789,
      1.543277,
      0.864053,
      NULL,
      1.353786,
      0,
      2.748691,
      3.691882,
      2,
      NULL,
      NULL,
      1,
      1.282179,
      NULL,
      0.075250,
      0.657877,
      4,
      2,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.042137,
      NULL,
      NULL,
      1.945270,
      1.152865,
      1.938557,
      0,
      1,
      1,
      0.520935,
      1.903616,
      0.486867,
      1.647271,
      0,
      0,
      NULL,
      1,
      0.682329,
      0,
      1.646167,
      0,
      1.164727,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      9,
      1.356277,
      5.070427,
      5,
      0,
      3,
      NULL,
      1.525147,
      2,
      NULL,
      6,
      NULL,
      7,
      7,
      4.315971,
      8.747299,
      1.314601,
      3,
      0.755287,
      2.197370,
      0.664035,
      2.335201,
      NULL,
      0.896293,
      NULL,
      4.993079,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0.540784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283546,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.815080,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327939,
      1.503138,
      1.991035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301984,
      0,
      0,
      0.935681,
      2.738743,
      NULL,
      1,
      3.325125,
      0.655193,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1.717392,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.346223,
      '31043',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


