set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22341312',
      66.678696,
      NULL,
      '4034022',
      281,
      NULL,
      NULL,
      2,
      '120233',
      4,
      ' 9- 7-1983',
      NULL,
      56,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.878927,
      1,
      0,
      0.178147,
      0.634585,
      1,
      1,
      0.247871,
      0,
      0,
      0,
      0,
      1,
      1.499851,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446050,
      0.918746,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.133492,
      0.990750,
      1,
      NULL,
      0.366451,
      0,
      0.120827,
      1,
      1,
      NULL,
      1,
      1,
      0.358142,
      0,
      0.555479,
      0.235298,
      1.796436,
      NULL,
      0.621081,
      6.030345,
      0,
      0,
      NULL,
      0.619780,
      7.129155,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.412171,
      NULL,
      1,
      2,
      4.749616,
      0.481818,
      NULL,
      4,
      4.082935,
      0.188836,
      3.660369,
      3,
      5,
      1.504713,
      1.683228,
      0,
      NULL,
      NULL,
      NULL,
      0.705959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.701356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811586,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052721,
      0.569481,
      0,
      2.067425,
      4,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.536536,
      1,
      1.232085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461212,
      0.578732,
      1.484672,
      0.750064,
      0.592579,
      1,
      0.688687,
      NULL,
      NULL,
      0.200433,
      0,
      NULL,
      1.557136,
      1.276186,
      1.906617,
      0.901884,
      NULL,
      0.074834,
      0.238327,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843645,
      NULL,
      '31432',
      NULL,
      1,
      '',
      '',
      '',
      2.272397,
      '4222',
      NULL,
      NULL,
      1.726013,
      4,
      3.652853,
      NULL,
      NULL,
      2,
      1,
      0,
      1.476518);
commit;
end;
/


