set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '00',
      39.908454,
      22,
      '2404440',
      21.505655,
      1,
      3,
      3,
      '302200',
      NULL,
      ' 1-12-1995',
      60,
      22.087470,
      NULL,
      NULL,
      3.101564,
      0,
      0.139949,
      1,
      0.995215,
      3.948287,
      0,
      NULL,
      NULL,
      0.615432,
      0.936536,
      1,
      NULL,
      NULL,
      NULL,
      1.894032,
      0.630483,
      1.371950,
      NULL,
      0.511976,
      1.768597,
      0,
      1.297968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223269,
      0.657387,
      1.819319,
      1.591131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373110,
      0,
      1.350563,
      1.922886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536825,
      1,
      0.680134,
      0.086720,
      0,
      3.763839,
      3.551750,
      1.447535,
      0.189484,
      1.400204,
      0,
      NULL,
      NULL,
      3,
      0,
      0.500010,
      1,
      1.413132,
      0.093351,
      NULL,
      1.890435,
      4,
      0,
      1.446335,
      1,
      1,
      5,
      0,
      1,
      1.205748,
      1.394262,
      0,
      NULL,
      NULL,
      1.657743,
      1.074835,
      2,
      4.404806,
      1.104420,
      NULL,
      5.872046,
      1.293864,
      3.522126,
      8,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.442116,
      1.362973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.215531,
      0,
      0,
      0.645324,
      1,
      0.381577,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633121,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      3,
      1.149766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.753180,
      1.844853,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922277,
      1.621097,
      1.350027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800565,
      NULL,
      0.971557,
      NULL,
      3,
      0,
      3.996314,
      0.420042,
      3.671838,
      1.393297,
      1.803464,
      1,
      NULL,
      1.272619,
      0,
      1.941379,
      NULL,
      1.945284,
      0.878410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '14312',
      NULL,
      '',
      1.020580,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2.918933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


