set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '34',
      49.230676,
      46,
      '4423333',
      81,
      1,
      2.763442,
      1,
      NULL,
      4.741710,
      ' 8-27-1991',
      49.039398,
      16.587390,
      1.568488,
      NULL,
      NULL,
      1.136094,
      0,
      0,
      0,
      0.371586,
      1.466696,
      NULL,
      NULL,
      1.091634,
      1.958780,
      0.914008,
      1,
      1.668413,
      NULL,
      1.356980,
      1.359962,
      1.707889,
      NULL,
      1,
      0.931759,
      1,
      1.033030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227332,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.155356,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.377406,
      1.996051,
      0.050252,
      1,
      1,
      NULL,
      1.353156,
      0.579212,
      NULL,
      1,
      1.430897,
      0.136285,
      2.503484,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1.642844,
      1,
      1.381577,
      2,
      0,
      0,
      3.719880,
      1,
      0.747350,
      1.575560,
      NULL,
      1.869627,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      2,
      5,
      1,
      4.694726,
      NULL,
      3.904055,
      3,
      1.261184,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.422129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015273,
      1,
      1,
      1,
      1,
      NULL,
      1.716983,
      0.992516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.326298,
      0.608682,
      4.732393,
      1.702630,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.028524,
      0.151802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998986,
      0,
      1.077851,
      2,
      3.139990,
      3.478928,
      NULL,
      2.994204,
      0,
      3.619775,
      1,
      NULL,
      1,
      1.253729,
      0.371124,
      NULL,
      1,
      1.849010,
      0.815457,
      1.643329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10030',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1.832970,
      '',
      NULL,
      '',
      5.760901,
      0,
      3,
      2,
      NULL,
      2,
      2.022191,
      2.080412,
      NULL);
commit;
end;
/


