set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23432340',
      7.993458,
      3.705943,
      '0431241',
      0.901449,
      2,
      0.765485,
      2,
      NULL,
      3.554813,
      ' 2-25-1991',
      9,
      48.577055,
      NULL,
      NULL,
      0.974596,
      1,
      1,
      1,
      0.017342,
      NULL,
      1.270144,
      2.738153,
      0,
      0.495043,
      1.596399,
      NULL,
      1,
      NULL,
      1,
      1.461968,
      0,
      0,
      1,
      0,
      1,
      1.892288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.710377,
      0,
      0.558676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487615,
      0.769271,
      1.052813,
      3.929076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.415656,
      NULL,
      4.950543,
      0,
      0.594832,
      0,
      1.694245,
      1,
      1,
      3,
      1.490744,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.469313,
      1.913282,
      1.833095,
      3.049101,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562796,
      1,
      0.663096,
      3,
      4,
      5,
      2.735104,
      0.556553,
      5.990797,
      3,
      3.350517,
      9,
      3,
      3,
      1.883779,
      NULL,
      0.944803,
      NULL,
      NULL,
      2,
      0.843212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.251828,
      0,
      NULL,
      0.302117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185382,
      NULL,
      NULL,
      NULL,
      NULL,
      3.521785,
      NULL,
      2.293606,
      NULL,
      1,
      7.380217,
      0.530801,
      1.161501,
      NULL,
      2.044465,
      1.345644,
      NULL,
      3.654990,
      1,
      5.989001,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686660,
      1,
      0.673603,
      NULL,
      2.944832,
      3.115912,
      0.744972,
      2.159580,
      1,
      NULL,
      1.920280,
      1,
      0.081878,
      1.203043,
      0.399575,
      1.186415,
      NULL,
      1,
      1,
      1.350641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.463716,
      '12321',
      NULL,
      NULL,
      0.228937,
      '',
      NULL,
      '',
      1.104333,
      '',
      NULL,
      NULL,
      1.864781,
      1,
      2,
      0,
      2,
      4,
      NULL,
      2.933211,
      3.864646);
commit;
end;
/


