set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      '12230322',
      21.139248,
      NULL,
      NULL,
      62.555825,
      2,
      1,
      1,
      '411401',
      0,
      ' 0-14-1996',
      48,
      NULL,
      0.569819,
      NULL,
      1.433219,
      0.642895,
      NULL,
      0,
      NULL,
      0.333837,
      1.936003,
      2,
      NULL,
      1,
      2,
      3,
      1,
      1,
      1,
      0,
      1,
      0,
      0.732666,
      1.939951,
      1.621486,
      1,
      5.524100,
      0,
      0.939421,
      1.632859,
      1,
      NULL,
      NULL,
      NULL,
      0.706598,
      NULL,
      NULL,
      3.445125,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.415573,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.672871,
      0.868094,
      0.845469,
      NULL,
      3,
      4.173553,
      1.399233,
      1.858975,
      2,
      1,
      0.435353,
      0.241761,
      5,
      1.223069,
      1,
      1,
      1,
      0.048358,
      NULL,
      1.795794,
      1,
      1.105384,
      1.532504,
      0,
      NULL,
      NULL,
      1.685273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      5.407362,
      2.867864,
      NULL,
      7.430531,
      NULL,
      1,
      2,
      11,
      9.373408,
      1.664942,
      1.922147,
      0,
      0,
      NULL,
      NULL,
      4.090747,
      0.995740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851785,
      4.838832,
      1,
      1,
      NULL,
      1.147439,
      0.612751,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.598645,
      0,
      0,
      5,
      0,
      3.556188,
      0,
      0.690271,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962346,
      6,
      1.612824,
      0.110167,
      NULL,
      1.135460,
      NULL,
      NULL,
      NULL,
      NULL,
      7.625217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      3.078554,
      2.523038,
      NULL,
      1,
      2,
      1,
      NULL,
      1.804461,
      1.487421,
      0,
      1.734619,
      1.208830,
      0,
      0.581964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '24111',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.227018,
      '',
      '',
      '',
      NULL,
      5.345559,
      NULL,
      0.288467,
      0,
      2.235075,
      NULL,
      NULL,
      2.539514);
commit;
end;
/


