set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13403343',
      33.356554,
      40.697200,
      NULL,
      25.295241,
      NULL,
      0,
      1,
      NULL,
      3.080986,
      ' 7- 3-2002',
      5.417612,
      15,
      1.904338,
      NULL,
      0,
      0,
      2,
      0.543511,
      0.136451,
      0,
      0.605698,
      NULL,
      0,
      1,
      NULL,
      1,
      0.518285,
      NULL,
      1.153269,
      0.837948,
      5,
      0.476725,
      0.973500,
      1,
      0,
      0.562013,
      5.690808,
      0,
      1,
      0,
      1.090306,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0.885422,
      NULL,
      1,
      1,
      2.330703,
      2.492832,
      0.658068,
      0,
      2,
      NULL,
      NULL,
      2.176511,
      0,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      1.785882,
      5,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      1.380810,
      NULL,
      NULL,
      1,
      0.619944,
      1.369078,
      1,
      1,
      1,
      1.201319,
      1,
      0,
      0.215387,
      1,
      1.812202,
      1.442922,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.623898,
      NULL,
      0.100464,
      NULL,
      3.858288,
      1,
      0.277894,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.202467,
      1,
      0,
      5.171102,
      3.239331,
      4,
      NULL,
      1.747727,
      6,
      1,
      2,
      NULL,
      1.517707,
      5,
      0.234794,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.897015,
      1,
      0,
      1.886658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.334836,
      NULL,
      NULL,
      3.078250,
      0.894698,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.944606,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.846418,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716469,
      3.072305,
      0,
      1.204015,
      1,
      NULL,
      2.590031,
      1,
      2.093463,
      NULL,
      NULL,
      0,
      0,
      0.704010,
      1,
      0,
      0,
      1,
      1.995150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.736714,
      NULL,
      NULL,
      '',
      0.623149,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      3.984059,
      4.502345,
      2,
      2.996217,
      NULL,
      3,
      NULL,
      0,
      3.008265);
commit;
end;
/


