set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '424',
      '33131232',
      67,
      52,
      NULL,
      NULL,
      NULL,
      3.990771,
      3,
      '213243',
      1,
      ' 3-23-1988',
      37.507238,
      1,
      0.620591,
      NULL,
      1.245488,
      1,
      NULL,
      0,
      1,
      0.339785,
      NULL,
      3,
      0.786396,
      1,
      5,
      NULL,
      0.478216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.909273,
      0,
      0,
      1.462914,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.307616,
      NULL,
      NULL,
      5.794408,
      NULL,
      0.913430,
      3.101757,
      1,
      1.790766,
      2,
      0,
      1.241519,
      3,
      1,
      1,
      1.681490,
      1,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      0.695606,
      1,
      1,
      1,
      1,
      3.666471,
      0.421774,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.446069,
      NULL,
      NULL,
      1.326356,
      1.100541,
      2.249718,
      0,
      5,
      0,
      1.981852,
      NULL,
      1,
      1.567681,
      NULL,
      0,
      NULL,
      0.040534,
      0,
      2.885235,
      6,
      2,
      1,
      5.528429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642187,
      0,
      NULL,
      NULL,
      5,
      4,
      2,
      3.003754,
      9.629637,
      6.201251,
      1.105213,
      6.170683,
      NULL,
      NULL,
      4,
      4,
      1,
      NULL,
      NULL,
      4.343910,
      1.830079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974847,
      1,
      1,
      1,
      0,
      0,
      1.511378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306141,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      4.796668,
      1,
      6.307755,
      4.120450,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.540666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.706214,
      0.281084,
      0.732322,
      2.802266,
      NULL,
      NULL,
      0.497370,
      1,
      0.334559,
      1,
      0,
      0.223443,
      0.916651,
      1,
      NULL,
      0,
      1,
      0.542534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '22043',
      '',
      '',
      0.644560,
      NULL,
      '',
      '',
      1.854275,
      '',
      '',
      NULL,
      4.567499,
      5,
      1.620902,
      1.872605,
      5,
      NULL,
      2.935403,
      NULL,
      3);
commit;
end;
/


