set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '33041043',
      4.636437,
      NULL,
      '2330223',
      169.894825,
      5,
      2.159717,
      0,
      '210300',
      0.086336,
      ' 0-22-1978',
      54.471992,
      21,
      NULL,
      NULL,
      1.899213,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.651028,
      1.932856,
      1,
      NULL,
      NULL,
      0.726225,
      1,
      1,
      1.727433,
      3.157243,
      1,
      0.719014,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      1.060692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.454198,
      0,
      NULL,
      0.224496,
      NULL,
      1.884175,
      0.609226,
      0,
      3,
      0,
      0.945522,
      2,
      NULL,
      0,
      NULL,
      3,
      3.047808,
      NULL,
      0.979605,
      0.467591,
      NULL,
      1,
      NULL,
      NULL,
      0.761161,
      NULL,
      NULL,
      1.804243,
      NULL,
      NULL,
      NULL,
      0,
      3.022772,
      0.160202,
      2.418869,
      3.628210,
      1,
      NULL,
      1,
      0.732013,
      0.227794,
      0,
      1,
      1.638305,
      0,
      NULL,
      NULL,
      1.161160,
      0.515896,
      NULL,
      NULL,
      2,
      0,
      0.834306,
      3,
      0.056624,
      3.859657,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.068816,
      7.355302,
      NULL,
      9.104174,
      7.353361,
      NULL,
      5.098439,
      NULL,
      1,
      4.929026,
      0,
      5.838033,
      1.820919,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160536,
      1.743859,
      NULL,
      0,
      0,
      0.328590,
      1.576507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040634,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.863189,
      6,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.343705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.539535,
      2,
      2.112031,
      1.819102,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.964174,
      1.748446,
      1.398048,
      0.512282,
      0,
      0.333931,
      1.206281,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.617262,
      '14302',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0.979738,
      0,
      0,
      NULL,
      0.652422,
      3,
      0.916298,
      3,
      2.421907);
commit;
end;
/


