set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      NULL,
      65.055675,
      16,
      '3202314',
      91.111343,
      3,
      1,
      NULL,
      '143203',
      NULL,
      ' 9-17-2002',
      4,
      NULL,
      0,
      NULL,
      1,
      1.214120,
      1,
      NULL,
      1.748050,
      NULL,
      0,
      NULL,
      0.129368,
      1,
      5,
      1,
      NULL,
      1,
      NULL,
      0.488762,
      3.841927,
      1,
      1.350194,
      1.450851,
      1,
      NULL,
      2.623292,
      1,
      0,
      1.442353,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.591321,
      0,
      1,
      1.615592,
      1,
      0,
      0.491475,
      2.781151,
      1,
      0,
      2.480079,
      1.103043,
      0,
      1.938550,
      1,
      0,
      0,
      3,
      0.569736,
      0.049619,
      NULL,
      1,
      1.365879,
      1,
      1,
      3,
      1.639459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383078,
      3.387093,
      0,
      0.491616,
      1,
      1.118565,
      2.922373,
      NULL,
      0,
      4.369599,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.316571,
      1,
      NULL,
      NULL,
      3.919988,
      NULL,
      1.443030,
      1.170623,
      0,
      0.024100,
      1.458839,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.965014,
      3.432863,
      1.388651,
      4.044765,
      0,
      3,
      0.976948,
      NULL,
      1,
      9.560241,
      10.808005,
      8.297339,
      NULL,
      2.964180,
      1.942409,
      1,
      NULL,
      NULL,
      0.155643,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881285,
      0.728458,
      NULL,
      1,
      0.927625,
      0,
      1.277935,
      0.599734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      2,
      NULL,
      NULL,
      2.125740,
      NULL,
      1.255240,
      4.495070,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886356,
      5.323833,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.185510,
      0,
      NULL,
      0,
      NULL,
      2.676372,
      1,
      0,
      2,
      0,
      0,
      1,
      0,
      1,
      0,
      1.061764,
      0.141855,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.797288,
      '14003',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5,
      3,
      1.329934,
      NULL,
      2.006576,
      NULL,
      2,
      1.786300,
      0);
commit;
end;
/


