set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      30,
      40,
      '1223013',
      NULL,
      5,
      NULL,
      NULL,
      '411030',
      3,
      NULL,
      25,
      15.101489,
      NULL,
      NULL,
      0.884183,
      1.008504,
      NULL,
      1,
      1.467618,
      0.163302,
      0,
      1.289547,
      0,
      1.818885,
      3.535222,
      1,
      0.672725,
      1.554778,
      NULL,
      1,
      4.816004,
      0,
      0.481302,
      1.238781,
      1.434820,
      0,
      NULL,
      0,
      4,
      1,
      1.341328,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.890835,
      2,
      0.312056,
      NULL,
      1.723937,
      NULL,
      0.524892,
      0.531731,
      3.960281,
      1.375096,
      1,
      0.565865,
      NULL,
      NULL,
      NULL,
      3.802352,
      1,
      0,
      0.308419,
      1.319844,
      NULL,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157753,
      0,
      0.715116,
      0.119896,
      2,
      0,
      1.611355,
      1,
      1,
      1,
      1,
      NULL,
      0.507895,
      1,
      0.117746,
      1,
      NULL,
      NULL,
      0.033952,
      2.651361,
      0,
      3.665297,
      1,
      0.135407,
      3.339040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652088,
      4.514201,
      4.239802,
      2,
      0.506944,
      2,
      2,
      5.924010,
      4.140378,
      NULL,
      4,
      2,
      1,
      1,
      0,
      2.267353,
      1.923143,
      NULL,
      NULL,
      9,
      1.639713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      0.056676,
      0.617478,
      1.646857,
      0.641384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.569357,
      1,
      1.426678,
      1,
      1,
      NULL,
      2,
      1,
      1.114199,
      1,
      0,
      0,
      0.270642,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.576151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.195652,
      2,
      3,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.306322,
      1.644257,
      0,
      0,
      1,
      NULL,
      1.233644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.450162,
      '42341',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.626080,
      NULL,
      NULL,
      0,
      5,
      1.849647,
      3.408654,
      NULL,
      3);
commit;
end;
/


