set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3002',
      '23044020',
      NULL,
      NULL,
      '1124212',
      5.461951,
      4,
      2.720519,
      0,
      NULL,
      NULL,
      ' 4- 7-1986',
      59,
      54.774386,
      1.470339,
      NULL,
      0,
      0.474272,
      1.872890,
      0.486132,
      0.111732,
      1.972658,
      1,
      1.379503,
      0.825551,
      0.623596,
      NULL,
      1,
      0,
      0,
      1.351980,
      0,
      4.022013,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0.104187,
      1.582224,
      0.404529,
      0,
      NULL,
      NULL,
      1.234359,
      NULL,
      NULL,
      4.812055,
      NULL,
      1.971667,
      3.970636,
      1.245862,
      0,
      2.182559,
      0,
      0.765016,
      0.360953,
      1.460215,
      NULL,
      1,
      3.802088,
      0,
      0,
      1,
      0.969789,
      1.216943,
      0,
      NULL,
      0.905154,
      3,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723680,
      0,
      1.056408,
      1.807119,
      1.905605,
      NULL,
      4.357074,
      0,
      0.185844,
      2,
      1.534298,
      0.343820,
      NULL,
      NULL,
      0.644066,
      1.397252,
      1.981548,
      1,
      1.596702,
      NULL,
      0,
      1,
      4,
      NULL,
      1.330373,
      5.374660,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.272352,
      2.560818,
      NULL,
      NULL,
      3,
      8.805653,
      1.001047,
      1.355576,
      6,
      2.592039,
      11.166347,
      1.958714,
      NULL,
      1.069669,
      4,
      0,
      NULL,
      NULL,
      0.812846,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799112,
      0,
      2,
      NULL,
      0.353486,
      0,
      1.091353,
      0.552857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      1,
      1.073845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455543,
      1,
      1.622820,
      1.885429,
      2.557566,
      3,
      2.381122,
      1.078494,
      5,
      4,
      1,
      0,
      1.989834,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      2.882476,
      0,
      NULL,
      NULL,
      2.356496,
      1.412894,
      0,
      NULL,
      0,
      1.446776,
      1.446828,
      0.906841,
      0,
      1.181457,
      0.199290,
      1.052034,
      0.883725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '22420',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      3.149938,
      3.181893,
      3.643721,
      4.704685,
      NULL,
      0.755748,
      3,
      0.689069);
commit;
end;
/


