set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3023',
      '22300324',
      36,
      NULL,
      '2334320',
      166.998366,
      NULL,
      1.727239,
      2,
      '113031',
      2.071367,
      ' 9-16-1998',
      39.754073,
      39,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.099776,
      0,
      0,
      0,
      0,
      NULL,
      4,
      1,
      1.873162,
      0.147701,
      1,
      1,
      3.475477,
      0,
      0.371421,
      1,
      1,
      0.992214,
      2,
      NULL,
      5.765589,
      1,
      1.170403,
      NULL,
      NULL,
      NULL,
      1.188133,
      NULL,
      NULL,
      0,
      1.344586,
      1.789784,
      2,
      0.629957,
      1,
      1.812911,
      1.556717,
      1,
      2,
      2.776286,
      1.483934,
      1,
      3,
      1,
      1.254433,
      3,
      NULL,
      1,
      NULL,
      1.490843,
      3,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.223167,
      NULL,
      NULL,
      0.024388,
      1.855655,
      1.321919,
      0.037564,
      1,
      1.374951,
      4,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      4,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      2.796597,
      2.100354,
      1,
      1.060766,
      2.672855,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.828128,
      4,
      4,
      NULL,
      3,
      9.437951,
      8.784566,
      NULL,
      7,
      1,
      2.746263,
      7.883625,
      2,
      1,
      1,
      3.660321,
      1,
      NULL,
      NULL,
      0.186567,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.038956,
      NULL,
      1.104610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.384967,
      0.448724,
      2.845580,
      1.713300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.028616,
      NULL,
      3,
      5,
      0.717897,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.556753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469777,
      0.559556,
      0,
      0,
      1,
      0.357921,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      0.846849,
      1.026482,
      0,
      NULL,
      1.869692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '32140',
      NULL,
      '',
      0.792534,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      3.858484,
      NULL,
      1.077667,
      7,
      1,
      0.457911,
      NULL,
      NULL);
commit;
end;
/


