set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2144',
      NULL,
      74,
      79,
      '1342223',
      NULL,
      3,
      2.460979,
      0,
      NULL,
      5,
      '11-23-1976',
      26.962663,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.529854,
      0,
      NULL,
      NULL,
      NULL,
      3.817777,
      NULL,
      1.739031,
      3,
      1,
      NULL,
      1,
      1.554911,
      0.273510,
      0,
      NULL,
      0.589994,
      0.798099,
      0.095418,
      1.123981,
      0,
      1,
      1,
      NULL,
      1.500415,
      0.300335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.447033,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692011,
      1.570342,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110507,
      0,
      0,
      NULL,
      0.546914,
      NULL,
      0.092443,
      0,
      2.883964,
      6,
      1,
      1.491654,
      1.773712,
      0.864882,
      NULL,
      0,
      0,
      0,
      NULL,
      0.884920,
      1,
      1,
      0.191487,
      1,
      0.038419,
      5,
      0,
      NULL,
      0,
      NULL,
      4,
      1,
      1,
      1,
      2,
      4,
      4.312783,
      0,
      NULL,
      1,
      2,
      0.508707,
      NULL,
      1,
      1,
      6,
      1.319894,
      3,
      0.659229,
      1.388476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1.604136,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688910,
      3,
      2,
      0.199468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.312230,
      NULL,
      3.021164,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.097233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.058264,
      1.481761,
      1,
      0.844155,
      3.677218,
      0,
      0,
      2,
      NULL,
      NULL,
      1,
      1.323372,
      0.939175,
      1,
      0,
      0.106422,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.243215,
      '31023',
      '',
      '',
      0.364698,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      3,
      0,
      0,
      3.927285,
      5.183568,
      0.699104,
      2,
      2.117356,
      NULL);
commit;
end;
/


