set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '3413004',
      3,
      1,
      1,
      3,
      '333433',
      NULL,
      ' 7- 8-1974',
      15.090433,
      NULL,
      0,
      NULL,
      1,
      1.828890,
      0,
      0.661161,
      1,
      1.626124,
      1.675297,
      0,
      1.088487,
      NULL,
      1,
      1,
      1.633656,
      3.218324,
      NULL,
      2.584379,
      0,
      NULL,
      0.300947,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      5,
      2.099150,
      1.149918,
      NULL,
      NULL,
      0.356823,
      NULL,
      NULL,
      10,
      3.436693,
      NULL,
      0,
      0.372037,
      1.829929,
      0,
      1.010320,
      2,
      NULL,
      0,
      0,
      0,
      1,
      0.829135,
      1,
      NULL,
      2,
      1,
      0,
      4,
      NULL,
      8,
      1,
      0,
      2.321808,
      0,
      NULL,
      NULL,
      1.090685,
      NULL,
      NULL,
      0.607960,
      1.094539,
      NULL,
      1,
      4,
      NULL,
      2,
      NULL,
      NULL,
      1.143555,
      1.897327,
      0.404465,
      0.289016,
      4,
      1.178446,
      1.056715,
      1.861747,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      2.965174,
      4,
      1.682516,
      0.978506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.937546,
      1.185920,
      0.195113,
      8,
      0,
      3,
      4,
      7.567156,
      8,
      NULL,
      2,
      1,
      NULL,
      3,
      NULL,
      0,
      0.647135,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887302,
      0.733762,
      NULL,
      0,
      1,
      0.496125,
      1.878131,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.801294,
      NULL,
      0.491548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323086,
      1,
      4,
      NULL,
      1,
      0,
      1.877541,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.655110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.326791,
      1.743588,
      3,
      1,
      0,
      1,
      2.841795,
      0,
      NULL,
      0,
      1,
      0,
      1.824580,
      1.575938,
      0,
      0.030021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44303',
      '34432',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


