set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      '323020',
      1.239308,
      ' 0-20-1981',
      38,
      NULL,
      0.263293,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      3.374119,
      NULL,
      1.308913,
      NULL,
      1.564636,
      1,
      0,
      1.664178,
      2,
      0,
      1.102751,
      9,
      1.008067,
      0.334472,
      1.758671,
      1.987986,
      0.448099,
      5,
      0,
      NULL,
      1.140543,
      NULL,
      1.377527,
      NULL,
      NULL,
      0.868961,
      NULL,
      NULL,
      4.489688,
      0.744114,
      0.430344,
      0.412396,
      0.471349,
      NULL,
      1,
      0.905298,
      2.059166,
      1,
      0,
      1.217673,
      1,
      NULL,
      2.153091,
      2,
      0.892015,
      1,
      0,
      0.981098,
      1,
      NULL,
      4.572313,
      NULL,
      1,
      0.132251,
      1.231033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.885104,
      0.857477,
      1.468680,
      1,
      1,
      0,
      1.749940,
      0.713698,
      0.447388,
      NULL,
      1,
      1.149572,
      0.965620,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1.034503,
      3,
      0,
      1.110281,
      1,
      2,
      1.158943,
      NULL,
      1.994617,
      1,
      NULL,
      1.049606,
      1.079442,
      0,
      1,
      3,
      NULL,
      0.531416,
      5,
      NULL,
      4,
      6,
      4,
      12.385080,
      0.100055,
      NULL,
      1.157167,
      1.825310,
      2,
      1.134615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.947104,
      0.209135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886183,
      NULL,
      NULL,
      NULL,
      NULL,
      3.702448,
      0.932092,
      3,
      1.178645,
      0.637934,
      0,
      1,
      3.915903,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.862109,
      NULL,
      2,
      NULL,
      0,
      0.583313,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013154,
      1.046198,
      1,
      NULL,
      0.020661,
      2,
      1.210549,
      NULL,
      NULL,
      1,
      1.901195,
      1.406587,
      1.247039,
      NULL,
      0,
      NULL,
      1.234558,
      0.841560,
      1,
      0.668268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.451652,
      '44104',
      '',
      NULL,
      0.286122,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


