set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '0312331',
      11.150627,
      4,
      NULL,
      2,
      '341014',
      NULL,
      ' 9- 4-1980',
      3.990735,
      NULL,
      1.187765,
      NULL,
      3.302462,
      1.504540,
      1.710069,
      0,
      0.784618,
      NULL,
      1.765594,
      NULL,
      NULL,
      1,
      1.957354,
      1.143088,
      1,
      1.930375,
      5,
      4,
      1,
      1,
      0.168792,
      NULL,
      NULL,
      3.557405,
      5,
      0,
      5.796431,
      0.719423,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8.481267,
      0.638356,
      3.321997,
      NULL,
      NULL,
      0.193507,
      1,
      NULL,
      0.114777,
      3,
      NULL,
      1,
      3.538190,
      1.744350,
      1,
      3.830492,
      2.798014,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.905393,
      NULL,
      NULL,
      1.054893,
      NULL,
      NULL,
      1,
      0,
      2.927287,
      1.141384,
      4.657011,
      1.057330,
      NULL,
      1,
      1,
      0.016359,
      1.474498,
      1,
      1.708646,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1.513096,
      1,
      7,
      NULL,
      NULL,
      1.964640,
      5,
      1.840646,
      4,
      0.130632,
      1.821451,
      NULL,
      5.385535,
      6.692471,
      7,
      NULL,
      0,
      8.609434,
      6,
      3.688499,
      2,
      1.546516,
      8,
      6,
      5,
      0,
      1,
      0,
      0.282133,
      NULL,
      0.026429,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0.343318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101794,
      NULL,
      NULL,
      NULL,
      NULL,
      4.672797,
      2.998645,
      2,
      1.527899,
      1,
      5.071675,
      4.369421,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.808152,
      1,
      1,
      4.157832,
      1,
      0,
      1.549352,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.173547,
      1,
      2.905671,
      1,
      2.502413,
      1.357644,
      0,
      1,
      0,
      1.211863,
      0,
      0,
      NULL,
      1.015156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '11003',
      '',
      1,
      '',
      '',
      '',
      0.184713,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


