set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '3224342',
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      ' 6-17-1977',
      37,
      NULL,
      1,
      NULL,
      NULL,
      1.560669,
      3,
      NULL,
      1.632612,
      0,
      0.647708,
      0,
      NULL,
      0.272392,
      NULL,
      NULL,
      0.225960,
      3.517776,
      0,
      0.154158,
      2,
      NULL,
      1.409251,
      0.811085,
      0,
      7,
      5.631788,
      0,
      0.544868,
      5.695440,
      1.387346,
      1.950782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      2,
      0.097890,
      0.500020,
      3.600167,
      0,
      3.030504,
      0.146598,
      2,
      1,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      2.233432,
      NULL,
      7.543297,
      2,
      0,
      0,
      1,
      0.440685,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.487363,
      0.391939,
      NULL,
      0.539968,
      1.694187,
      0,
      2,
      1,
      1,
      1,
      0.145270,
      0,
      0,
      0.611333,
      0,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.618707,
      4.529824,
      1.364507,
      NULL,
      NULL,
      NULL,
      NULL,
      7.435217,
      5.326319,
      NULL,
      1.969595,
      0,
      7.956415,
      0.528464,
      3.112709,
      NULL,
      1,
      0,
      2.333561,
      NULL,
      NULL,
      0.152287,
      2,
      0.738521,
      1.052258,
      0,
      3.441948,
      0.731767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676354,
      0.390661,
      0,
      NULL,
      1.894703,
      1,
      1.307652,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.447702,
      0,
      NULL,
      NULL,
      NULL,
      0.045692,
      NULL,
      3,
      7,
      NULL,
      0,
      5.124577,
      0,
      NULL,
      NULL,
      1.791404,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346195,
      NULL,
      0.650998,
      0,
      1,
      NULL,
      2.616714,
      1,
      0,
      2.721306,
      0.352867,
      1.322308,
      0,
      1,
      0,
      1,
      1.912099,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.066990,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


