set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      14.650845,
      1,
      3,
      3,
      '010034',
      NULL,
      ' 5-12-1989',
      26.408223,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.316463,
      NULL,
      1.812022,
      1.374156,
      NULL,
      0,
      NULL,
      1.165581,
      0,
      0,
      0,
      0.369567,
      0,
      0,
      NULL,
      0.798157,
      NULL,
      0.063050,
      1,
      NULL,
      1.651410,
      NULL,
      NULL,
      0,
      1.857967,
      1.076595,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.379503,
      NULL,
      1.622121,
      0,
      0.277203,
      1,
      1,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      0.482056,
      1.832191,
      NULL,
      0,
      NULL,
      NULL,
      6.452144,
      NULL,
      2,
      0.523719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.938852,
      1,
      0.084990,
      NULL,
      1,
      0,
      0.494656,
      0,
      0.804984,
      0,
      0,
      NULL,
      0,
      NULL,
      1.848739,
      1.549252,
      1.910175,
      1,
      NULL,
      1,
      2,
      1,
      0.378906,
      5,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.817721,
      1.738520,
      0.084914,
      3.254949,
      1,
      2,
      7.436705,
      2,
      1,
      NULL,
      7,
      1.896892,
      NULL,
      3.520424,
      1.393298,
      0.308676,
      0.234661,
      NULL,
      0.476435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231164,
      1.519451,
      1,
      1,
      0,
      1,
      0.558703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.217882,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.237429,
      1,
      0.677928,
      7,
      2.641974,
      2,
      1.568045,
      NULL,
      NULL,
      NULL,
      1.189760,
      2.244318,
      1.201363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.127494,
      0.441784,
      NULL,
      0.724637,
      1,
      1,
      0.312211,
      1.921900,
      0.033816,
      1,
      NULL,
      0.537257,
      NULL,
      0.927539,
      1,
      NULL,
      0.661983,
      1.457040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.400580,
      '02042',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


