set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '3322430',
      17,
      5,
      NULL,
      NULL,
      '302002',
      2.473739,
      '11- 9-2001',
      12,
      NULL,
      0,
      NULL,
      0,
      1,
      1.468158,
      1.142295,
      1,
      2.713592,
      0.331215,
      1,
      1,
      0,
      1.772400,
      0.841273,
      0,
      2.059425,
      1,
      1,
      1.759245,
      1,
      NULL,
      1.977064,
      3.090857,
      7.788211,
      2,
      0,
      NULL,
      1.847163,
      2.618940,
      1.704115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632948,
      11,
      10.122374,
      2,
      0,
      2.630077,
      NULL,
      2.470898,
      NULL,
      3,
      1,
      2,
      1.373688,
      3.362896,
      1.306024,
      1,
      1.449181,
      2.316466,
      3.934592,
      5,
      1.378354,
      8.133182,
      5,
      1,
      NULL,
      3,
      0.706801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.927029,
      1.041627,
      1,
      1,
      1.380181,
      NULL,
      1.670387,
      1,
      1,
      1,
      0,
      1,
      1.487878,
      1.844045,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873740,
      2,
      NULL,
      NULL,
      1,
      1,
      0.693793,
      3,
      2,
      5.412142,
      3.919888,
      NULL,
      NULL,
      1.775673,
      0,
      6,
      7,
      4,
      7.229316,
      NULL,
      0.690161,
      8.666696,
      NULL,
      3.019753,
      2,
      0.141895,
      1.712091,
      0,
      1.018630,
      1.751114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0.940031,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      1,
      1,
      5.547399,
      1,
      NULL,
      NULL,
      1,
      1.185330,
      1.919615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.044002,
      1.836228,
      NULL,
      3,
      NULL,
      1.338140,
      NULL,
      0.771927,
      1.133882,
      NULL,
      0.479969,
      1,
      1.913182,
      0,
      0,
      0.367016,
      0.372810,
      1.063502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '34413',
      '43400',
      '',
      1,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


