set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '3302044',
      34.253953,
      1,
      NULL,
      3,
      '110110',
      NULL,
      ' 6-10-1975',
      14,
      NULL,
      1,
      NULL,
      1.981481,
      0,
      0.975136,
      0,
      0,
      NULL,
      1.812733,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.776314,
      3,
      NULL,
      NULL,
      1.808342,
      1,
      0.446290,
      3,
      8,
      1.459692,
      1,
      5.203424,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.401365,
      9.906941,
      0.257254,
      0,
      2.884849,
      NULL,
      1,
      NULL,
      0.528260,
      3,
      3.323089,
      1.322011,
      1.940918,
      1.389326,
      2,
      NULL,
      1.202785,
      3,
      1,
      5.232968,
      1,
      5,
      6.692232,
      1,
      0,
      2.005666,
      1.085184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.750438,
      0.965081,
      2.212997,
      NULL,
      1.482229,
      1.223493,
      0,
      1,
      1,
      0.691524,
      1,
      1,
      1,
      NULL,
      1.424077,
      1.256652,
      1,
      NULL,
      0,
      5.649694,
      2,
      0,
      4.270933,
      NULL,
      1.568449,
      0,
      7,
      5.110842,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      NULL,
      4.474712,
      3.516571,
      NULL,
      8,
      1.083041,
      5,
      1,
      3,
      NULL,
      2.822597,
      NULL,
      3.793729,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047061,
      1,
      0,
      NULL,
      1.913613,
      1.765330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984728,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.757777,
      0.334713,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.891483,
      0.251359,
      0,
      0,
      0,
      0.898060,
      1.022083,
      NULL,
      NULL,
      0,
      3.841396,
      1.969417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.656248,
      1,
      1.020030,
      1,
      1.301952,
      1,
      2.101481,
      1.473738,
      NULL,
      1.222036,
      1.789085,
      0.214579,
      0,
      0,
      NULL,
      NULL,
      1.161948,
      0.747672,
      1.067053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060296,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573614,
      NULL,
      NULL,
      NULL,
      NULL,
      2.218756,
      1.538551,
      1.826830,
      NULL,
      NULL,
      1.078081,
      1,
      1,
      NULL,
      '32000',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


