set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '3433230',
      27,
      2,
      0,
      2,
      '003130',
      3.556183,
      ' 5- 4-1998',
      23,
      NULL,
      1.622315,
      NULL,
      0.719360,
      0.122579,
      NULL,
      1,
      1.364714,
      3,
      NULL,
      1.920328,
      0.454972,
      1.236088,
      0,
      1,
      0.774431,
      1.157629,
      5.472783,
      2,
      1.871028,
      1,
      0.392770,
      2,
      6.447872,
      2.580287,
      4,
      1,
      5.379060,
      5.021396,
      1,
      0.170694,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11,
      NULL,
      2,
      1,
      2,
      2,
      2.671388,
      2,
      NULL,
      NULL,
      2.470300,
      NULL,
      3.797651,
      1,
      0.546027,
      0.396804,
      0,
      3,
      NULL,
      2.210204,
      1,
      3,
      9,
      1,
      1,
      3.152096,
      0.389016,
      NULL,
      NULL,
      1.098473,
      NULL,
      NULL,
      1.410647,
      NULL,
      2.945616,
      1,
      3.426688,
      0.630543,
      1.105692,
      1.490421,
      0,
      0.884802,
      NULL,
      1.527655,
      0,
      0.636725,
      1.212376,
      1,
      1,
      0,
      1.843229,
      NULL,
      0,
      0,
      NULL,
      4,
      0.650736,
      0,
      5,
      1,
      4.051614,
      1.444637,
      4.966611,
      NULL,
      3.269817,
      0,
      1,
      NULL,
      7,
      2.198535,
      3,
      3.711660,
      1.694068,
      1.422423,
      1,
      6.395427,
      0.790278,
      0.150862,
      2.506180,
      3.012692,
      0,
      0.042750,
      1.800734,
      2.464134,
      0.945694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.913804,
      NULL,
      1.161229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.614707,
      0,
      NULL,
      NULL,
      2.809629,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.461245,
      NULL,
      NULL,
      1.056792,
      1,
      0,
      4.132172,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.608074,
      NULL,
      0.533173,
      1.482533,
      0,
      0,
      1,
      1.676395,
      0.174183,
      NULL,
      0,
      0.320484,
      0.095921,
      2.610001,
      1,
      0.940452,
      1.896360,
      NULL,
      0,
      NULL,
      0,
      1.184201,
      0.404022,
      1.176338,
      1,
      0.651281,
      NULL,
      NULL,
      0,
      NULL,
      1.205002,
      NULL,
      0.496397,
      1.358029,
      NULL,
      1.102676,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.663727,
      1,
      NULL,
      1.010920,
      1,
      0,
      1,
      4,
      '42042',
      '23214',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


