set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '3104410',
      54.104460,
      0,
      0,
      NULL,
      '144040',
      0.792501,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.666450,
      0,
      1.561401,
      3,
      0.399431,
      1.106609,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      2,
      0.882749,
      0.156336,
      0,
      0.510585,
      NULL,
      1.170820,
      6,
      0,
      4.982142,
      2,
      NULL,
      1.200606,
      NULL,
      NULL,
      1.584732,
      NULL,
      NULL,
      0.289450,
      0.809900,
      1.301854,
      1,
      0.836141,
      2,
      3.805228,
      3,
      3.265532,
      0.135321,
      NULL,
      0.725231,
      1.359970,
      1,
      2.868031,
      NULL,
      NULL,
      3,
      0,
      5.796625,
      1.513301,
      3,
      3,
      0,
      0,
      2.310384,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.493911,
      NULL,
      1.257992,
      1.331653,
      4.261705,
      1,
      3,
      1.774747,
      NULL,
      1,
      NULL,
      NULL,
      1.343159,
      0.385695,
      0,
      0.135856,
      NULL,
      0,
      0.694068,
      NULL,
      1,
      NULL,
      NULL,
      0.165104,
      NULL,
      1.478788,
      2,
      0.046853,
      4.815075,
      0,
      4,
      0,
      1.433090,
      0.368386,
      4.536943,
      3.869518,
      5.794554,
      0,
      6,
      1.921063,
      7.017844,
      1.122519,
      3,
      4,
      2.497538,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.636789,
      0,
      1,
      1,
      NULL,
      0,
      0.462831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524338,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.149619,
      1.325753,
      NULL,
      NULL,
      NULL,
      2.965250,
      0,
      1.690160,
      4,
      1.114531,
      1,
      1.172227,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.379651,
      3,
      1,
      NULL,
      0.177003,
      0,
      0,
      2.783616,
      0,
      0,
      0,
      1.494698,
      0.299297,
      2.969417,
      0,
      NULL,
      NULL,
      2,
      2.724389,
      3.626331,
      NULL,
      0,
      NULL,
      2.710861,
      1.310491,
      1.618670,
      0,
      1,
      1,
      NULL,
      0.835049,
      1.462428,
      1.688001,
      1,
      1.314763,
      1.960451,
      0.361276,
      0.054900,
      1.446174,
      1.815153,
      0.014826,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015733,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.008369,
      0.829888,
      NULL,
      1.618229,
      1,
      1,
      0,
      0,
      '41434',
      '01040',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


