set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '0424331',
      18,
      3,
      NULL,
      2,
      '313312',
      NULL,
      ' 5-24-2000',
      23.536957,
      NULL,
      0,
      NULL,
      0,
      1.328568,
      1,
      NULL,
      1,
      0.601750,
      0,
      0.040912,
      3.814296,
      0.745025,
      NULL,
      1,
      0.867952,
      NULL,
      0,
      0,
      NULL,
      0,
      3.304122,
      1,
      NULL,
      3.004321,
      2.688453,
      0,
      3.949043,
      1.999093,
      3,
      1,
      NULL,
      NULL,
      1.116209,
      NULL,
      NULL,
      8.389693,
      0.208512,
      2,
      3,
      1.530223,
      1,
      NULL,
      0.632033,
      2.568969,
      2.242422,
      NULL,
      NULL,
      3.458641,
      3,
      NULL,
      0,
      0,
      0,
      2.498693,
      2.923732,
      1,
      1.680540,
      4,
      0,
      NULL,
      0.123117,
      0.753406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624593,
      7.061419,
      0.777878,
      2.783781,
      0,
      0,
      NULL,
      0,
      1.186691,
      1.883731,
      2,
      1,
      2.086214,
      0.190360,
      0,
      1.912053,
      NULL,
      0,
      NULL,
      NULL,
      0.221009,
      NULL,
      0,
      0,
      NULL,
      4,
      1,
      5.942261,
      NULL,
      2.124814,
      0.847678,
      0.190478,
      0,
      2.347422,
      2,
      0.381464,
      9.607812,
      6,
      1,
      4.762656,
      3.405172,
      1,
      7.078193,
      4.461211,
      0.996916,
      0,
      3.375757,
      1,
      1,
      1,
      NULL,
      0.804523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973909,
      NULL,
      6.456357,
      3,
      NULL,
      1,
      1.042612,
      0,
      0,
      1.086822,
      3,
      2,
      0,
      0.599279,
      NULL,
      NULL,
      NULL,
      0.629636,
      0,
      3.139202,
      5,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      3,
      0.683674,
      NULL,
      0,
      1.196876,
      2,
      1,
      0.750516,
      0.048997,
      0.824313,
      NULL,
      NULL,
      0,
      NULL,
      1.048240,
      1,
      1,
      0.084484,
      0,
      NULL,
      3,
      NULL,
      0.185051,
      0,
      1,
      0,
      0.426393,
      0,
      0,
      0.985393,
      0.897254,
      0,
      NULL,
      1,
      0.036925,
      1.600872,
      3,
      1.547995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643037,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.775283,
      1.600186,
      NULL,
      1,
      1.538157,
      1.267095,
      1,
      1,
      '30442',
      '00324',
      '',
      0.511750,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


