set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '3304002',
      8.803950,
      5,
      2.250252,
      1,
      '200442',
      2,
      ' 7-24-1982',
      37.305350,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      2,
      1,
      0.546538,
      0.755975,
      0.886063,
      2,
      1,
      NULL,
      1.419647,
      NULL,
      3,
      0.809309,
      0,
      3.190784,
      2,
      2.286458,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.832555,
      1.107334,
      NULL,
      NULL,
      1.071662,
      NULL,
      NULL,
      2.626481,
      3,
      2.504851,
      3.798919,
      3,
      1.922642,
      3.205163,
      2.806480,
      0.556243,
      1,
      1,
      2.049688,
      0.180226,
      3.981988,
      NULL,
      0,
      2,
      3.362989,
      3.401913,
      NULL,
      1,
      1.800595,
      7,
      1,
      0,
      NULL,
      0.162921,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      3.794759,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.553903,
      0,
      1,
      0,
      1.248806,
      0.667136,
      NULL,
      0,
      0,
      0,
      1.235347,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      0.678672,
      6,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.091119,
      1.686342,
      NULL,
      2.278457,
      NULL,
      7.924032,
      2,
      NULL,
      1.783488,
      5.194110,
      NULL,
      13,
      NULL,
      2,
      1,
      1.616100,
      1,
      0.507465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.105444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.769411,
      0,
      3.788457,
      0.026111,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.913510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041418,
      NULL,
      0,
      3,
      0.708534,
      NULL,
      3,
      NULL,
      0.683186,
      0.746808,
      NULL,
      0.189657,
      1.194526,
      0.745027,
      0.293591,
      0,
      1,
      0,
      0,
      2.533209,
      NULL,
      0.201393,
      1,
      0.253953,
      NULL,
      1.485731,
      NULL,
      0.442083,
      0.108026,
      1.047979,
      1,
      1,
      1.214843,
      0.438556,
      1.672520,
      0,
      1,
      0.556841,
      1.045263,
      0,
      1.385846,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '40122',
      '44324',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


