set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      NULL,
      NULL,
      9.038678,
      '0003343',
      8.910421,
      4,
      1,
      3,
      '311423',
      5.730553,
      ' 8- 3-2001',
      38,
      31,
      1.033428,
      NULL,
      0,
      0,
      NULL,
      0.669735,
      0,
      3,
      0,
      1,
      0.286726,
      NULL,
      NULL,
      1.760611,
      0,
      7,
      2.490722,
      NULL,
      2,
      1,
      NULL,
      0.588561,
      5.636074,
      5,
      1,
      1,
      1.705459,
      0.866526,
      2.452841,
      1.510476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      7,
      0.756110,
      NULL,
      3,
      NULL,
      3.047286,
      1,
      3.610226,
      2.174683,
      3.270529,
      2,
      NULL,
      1,
      1,
      2,
      2,
      NULL,
      1.142169,
      4.971203,
      7.840781,
      8.360670,
      1,
      1,
      0,
      1.028858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.756972,
      5.649709,
      0,
      1.841987,
      2.333078,
      0.634423,
      NULL,
      NULL,
      1.411509,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0.485907,
      4,
      0.018383,
      4,
      1.700110,
      NULL,
      5,
      0.824813,
      4.716690,
      NULL,
      3.575426,
      NULL,
      NULL,
      2.876758,
      NULL,
      0.770360,
      NULL,
      9,
      NULL,
      6,
      NULL,
      NULL,
      2.124767,
      0.997749,
      5.720714,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1.012368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.625536,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.312049,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.380967,
      0,
      3.768790,
      1,
      4.107752,
      0,
      0.707723,
      NULL,
      NULL,
      NULL,
      0.870926,
      0.140046,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.450359,
      0.597171,
      2,
      1,
      2.012947,
      NULL,
      3.102505,
      1.076145,
      1.535432,
      1,
      1,
      0,
      NULL,
      1.154675,
      1.222187,
      1.605127,
      NULL,
      0.467669,
      3.753497,
      1.548326,
      3,
      0,
      1.731093,
      0,
      2.263276,
      2.830466,
      1.515364,
      1,
      0,
      0,
      0.411126,
      1.219399,
      NULL,
      0.601431,
      NULL,
      0,
      1.709995,
      NULL,
      0.529611,
      0,
      1.386137,
      1.293783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.042787,
      '32331',
      '00043',
      NULL,
      1.943793,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


