set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      9,
      3,
      3.766523,
      2,
      NULL,
      1,
      ' 5-28-1988',
      47,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.553534,
      0,
      1.737450,
      0,
      1.229445,
      9.069359,
      1,
      0,
      7,
      0,
      1.442354,
      0,
      NULL,
      0.690392,
      4,
      0,
      6.255592,
      6.498071,
      NULL,
      NULL,
      0,
      2,
      1.103454,
      NULL,
      NULL,
      0.735398,
      NULL,
      NULL,
      5,
      NULL,
      0.756679,
      2,
      1.472660,
      0,
      NULL,
      0,
      NULL,
      1,
      0.236767,
      0.506462,
      3,
      0.905255,
      2.412445,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1.224221,
      1.191365,
      NULL,
      NULL,
      0.355345,
      NULL,
      NULL,
      1,
      1.813759,
      0.818131,
      1.272527,
      NULL,
      5.771581,
      1,
      NULL,
      1.412723,
      0.942825,
      0.980798,
      1.405724,
      NULL,
      0.227546,
      0.286460,
      1.067777,
      1.064807,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      7.871522,
      1,
      3,
      3.097128,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615601,
      1,
      0.424443,
      1.035445,
      5,
      0,
      2,
      NULL,
      3,
      3.089116,
      9,
      7,
      9.813573,
      0.451497,
      NULL,
      1,
      2,
      1,
      1.429405,
      0.551949,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7.282912,
      1.978682,
      0.920910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609705,
      0,
      0.316205,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700144,
      2,
      NULL,
      4.847042,
      2,
      1.188232,
      NULL,
      NULL,
      NULL,
      1,
      2.712587,
      1.987776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      2.205293,
      0.227936,
      1.147194,
      0.977150,
      2,
      3.171361,
      1,
      0.120936,
      1,
      NULL,
      1.083103,
      NULL,
      NULL,
      1.571316,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.964904,
      NULL,
      '',
      '',
      0.085323,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


