set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '4444403',
      7,
      1,
      NULL,
      NULL,
      '440023',
      0.480026,
      ' 7-14-2003',
      26,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.883083,
      1.935213,
      1,
      9.892544,
      0.004834,
      0.661674,
      4,
      1,
      NULL,
      7.676887,
      0,
      NULL,
      7,
      0,
      2,
      4,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.667750,
      3,
      1.245464,
      0,
      2,
      1,
      0,
      NULL,
      0,
      2,
      1.999578,
      3,
      0,
      0.892801,
      3,
      2,
      1.470537,
      0.533924,
      1.379826,
      NULL,
      NULL,
      1.328118,
      2,
      0,
      NULL,
      1.544241,
      0.151842,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.600245,
      1,
      2,
      3.261535,
      5,
      NULL,
      3.916623,
      1,
      1,
      NULL,
      1.885012,
      1,
      NULL,
      4,
      1,
      0,
      NULL,
      1.433818,
      0,
      NULL,
      0,
      2.576993,
      0,
      3,
      NULL,
      0,
      2,
      0,
      1.303286,
      2.689967,
      NULL,
      4.118787,
      0.555840,
      NULL,
      NULL,
      5,
      0.762037,
      1,
      3,
      5,
      3.539875,
      0.973569,
      2.247968,
      3,
      NULL,
      0.536374,
      NULL,
      0,
      0.620456,
      0.703740,
      1,
      NULL,
      0.005105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532823,
      1.996789,
      2,
      1,
      1.681122,
      NULL,
      1.311195,
      0.953044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.551175,
      NULL,
      2,
      2.964078,
      0.525664,
      1,
      0.949248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.517332,
      NULL,
      3.152305,
      1.555852,
      1,
      3.352531,
      0,
      2,
      1,
      NULL,
      1.621120,
      NULL,
      1.649043,
      0,
      0.653841,
      1.378381,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '42414',
      '',
      NULL,
      0.144174,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


