set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '2334324',
      11.917233,
      3,
      NULL,
      NULL,
      NULL,
      2.511343,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.735277,
      1,
      1.665155,
      2.624760,
      1.154880,
      0.045870,
      0.572612,
      1,
      0,
      0,
      0,
      1.470246,
      0.693968,
      NULL,
      3.594296,
      NULL,
      0.465051,
      1.120927,
      1,
      1,
      1,
      0,
      2,
      1.902748,
      1.902795,
      NULL,
      NULL,
      NULL,
      1.990544,
      NULL,
      NULL,
      1,
      1.261972,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765482,
      1.268139,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515426,
      1,
      1.813320,
      5,
      3.315660,
      NULL,
      NULL,
      1.523328,
      1,
      1,
      NULL,
      1.305072,
      0,
      0,
      0,
      0.849350,
      0,
      0,
      0.170206,
      NULL,
      0.378624,
      2,
      1,
      NULL,
      5,
      0.383575,
      2,
      0.549256,
      0.613737,
      NULL,
      5,
      NULL,
      NULL,
      3,
      0.395682,
      1.607346,
      NULL,
      1.013984,
      2,
      4,
      NULL,
      2,
      2.012069,
      6.414133,
      5,
      3,
      NULL,
      NULL,
      3.302450,
      0.416263,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.725663,
      0,
      1,
      NULL,
      1.113738,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692471,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.125646,
      1.717914,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.975463,
      1.322086,
      1.993902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.574327,
      0,
      3.804454,
      3,
      1.246729,
      1,
      1.484853,
      0.136881,
      1.401638,
      NULL,
      1,
      0.689002,
      0,
      1,
      1,
      0.969070,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.934777,
      '30404',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


