set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '0330134',
      14,
      2,
      0,
      1,
      '101043',
      0.086066,
      ' 1-19-1991',
      36.214804,
      NULL,
      1,
      NULL,
      0.575947,
      1.127596,
      2.030076,
      0.310533,
      0.807794,
      0,
      1.323892,
      0.643818,
      1.910703,
      0,
      4.084538,
      1,
      1,
      6,
      0,
      0,
      3.110871,
      0,
      1,
      5.042639,
      6.867594,
      0.934964,
      6.738377,
      1,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.788937,
      NULL,
      NULL,
      5.140505,
      0,
      1,
      NULL,
      0,
      0,
      0.260224,
      NULL,
      NULL,
      0,
      1,
      1.498809,
      2,
      3,
      3.633140,
      0,
      1,
      1.008477,
      1,
      3.347433,
      1.383375,
      1,
      5.656982,
      0,
      NULL,
      2,
      0.556541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065145,
      0,
      0,
      5,
      4,
      1.926009,
      1.124079,
      1.742706,
      1,
      1.677929,
      NULL,
      0.818064,
      4,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      1.867331,
      1,
      0.668021,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2.430254,
      6,
      9,
      6,
      0.239698,
      9.610637,
      3.810561,
      NULL,
      2,
      3.293125,
      NULL,
      2.308637,
      2,
      0.943985,
      0,
      3.644975,
      0.951498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.776038,
      2,
      2,
      1,
      1.600751,
      2.874552,
      1.822612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.173674,
      1,
      1.854615,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.321049,
      1.547945,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.958569,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.095128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      1.911061,
      1,
      0,
      NULL,
      1,
      1.196810,
      NULL,
      1.474295,
      0,
      1.735334,
      NULL,
      1.539739,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.573079,
      '43023',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.911971,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


