set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '0041332',
      NULL,
      5,
      0,
      NULL,
      '312234',
      1,
      NULL,
      42.890196,
      NULL,
      1.840326,
      NULL,
      0,
      0,
      NULL,
      0,
      0.937020,
      2.805165,
      1,
      0,
      0,
      NULL,
      7,
      NULL,
      NULL,
      7,
      NULL,
      1.523428,
      NULL,
      6.749185,
      6.241958,
      7,
      7,
      1.432286,
      1.806046,
      1,
      5.884703,
      2.782575,
      1.177905,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.537642,
      1,
      0,
      2,
      1,
      NULL,
      0,
      1,
      2,
      0.384687,
      NULL,
      0.172710,
      2.344144,
      3,
      0.153076,
      NULL,
      0.575814,
      1,
      NULL,
      NULL,
      0.988590,
      1.772486,
      3.881644,
      0,
      2,
      2.440360,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782481,
      2.909703,
      1.984175,
      1,
      3.608678,
      1.350025,
      1,
      0.523538,
      0.002228,
      1,
      1.498695,
      1.932457,
      NULL,
      0.145635,
      0,
      1.378050,
      1,
      NULL,
      NULL,
      0.085984,
      NULL,
      NULL,
      3.027964,
      1,
      NULL,
      NULL,
      NULL,
      3,
      4.162380,
      5,
      1.571632,
      NULL,
      2.115478,
      0,
      1.556287,
      2,
      0.666095,
      1,
      6.947990,
      NULL,
      NULL,
      10.986769,
      8,
      3,
      8.754650,
      4,
      NULL,
      0.209224,
      1.189145,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.783806,
      0,
      0,
      0,
      NULL,
      1.438453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.490531,
      NULL,
      8,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.902787,
      1.449473,
      NULL,
      NULL,
      NULL,
      5.880131,
      1.097829,
      0,
      1.861966,
      NULL,
      NULL,
      1.093630,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.153828,
      2.254342,
      0,
      3,
      1.835316,
      0.842558,
      0.812218,
      2.379197,
      0.755950,
      1.262908,
      1,
      0,
      0,
      1,
      1.677652,
      1,
      1.615958,
      0.718847,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.351637,
      '00122',
      '',
      '',
      0,
      '',
      '',
      '',
      1.946118,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


