set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '2011204',
      12.079653,
      2,
      2.457879,
      1,
      '330104',
      1.328229,
      ' 2-25-1986',
      11,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.069852,
      NULL,
      NULL,
      0,
      1.012850,
      1,
      NULL,
      NULL,
      0,
      1.166885,
      4,
      3.323446,
      1,
      2.416986,
      3.047656,
      2.965861,
      1,
      1,
      NULL,
      7.390754,
      NULL,
      5.280423,
      0.750642,
      NULL,
      1,
      NULL,
      NULL,
      1.170369,
      NULL,
      NULL,
      NULL,
      0.776314,
      0.646493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116824,
      1,
      0.601221,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893350,
      2,
      0,
      2.536532,
      5.911271,
      3,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0.217002,
      0,
      1.122180,
      1.559751,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.926511,
      0,
      0.004958,
      NULL,
      NULL,
      2.994626,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.870485,
      2.336278,
      1.576592,
      3,
      3,
      NULL,
      0.859987,
      8,
      4,
      NULL,
      0,
      5,
      1.154226,
      0.399352,
      5.839114,
      2.655510,
      0.295559,
      0,
      NULL,
      1.270301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1.411907,
      0.777131,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.035271,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736127,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2.974003,
      NULL,
      4,
      NULL,
      1.656435,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.346538,
      0.292359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.805901,
      3.732852,
      NULL,
      0,
      2,
      1,
      2,
      0,
      2.293191,
      3.946246,
      1.139155,
      1.412843,
      0.075476,
      1,
      0.436202,
      NULL,
      0.554927,
      0,
      1.865631,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '32202',
      '',
      '',
      0.681665,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


