set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '2310203',
      16.228009,
      0,
      0.240239,
      NULL,
      '402244',
      2,
      ' 0-15-1975',
      20,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.543594,
      2.984388,
      0,
      1,
      0.914127,
      1.229777,
      0.095766,
      0,
      1,
      3.851685,
      3,
      1,
      7.841800,
      0,
      NULL,
      3.607568,
      3,
      0,
      1,
      0,
      2.289842,
      0,
      NULL,
      1.099980,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.189236,
      NULL,
      1.922462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811535,
      0.577003,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.106664,
      0,
      NULL,
      2.230478,
      2.206869,
      0.423969,
      0.887649,
      0,
      1.695940,
      1.852519,
      1.597544,
      0,
      NULL,
      0.565981,
      NULL,
      1,
      1.941663,
      NULL,
      NULL,
      0,
      4.933989,
      1.305571,
      0.877471,
      4,
      1,
      6.194236,
      1,
      1.834664,
      2,
      1.933117,
      4.482288,
      2.952567,
      2.042559,
      2,
      1.294308,
      NULL,
      4,
      6,
      6,
      1,
      9,
      NULL,
      3.714731,
      2.705916,
      3,
      NULL,
      0,
      3,
      NULL,
      0,
      1.264432,
      1.665109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954641,
      NULL,
      NULL,
      2,
      NULL,
      1.572654,
      1.095098,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.481249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.813345,
      0.111184,
      0.624748,
      0.979381,
      1.396032,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.663216,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.210179,
      0.827291,
      2.391639,
      NULL,
      1,
      1.330266,
      3.831332,
      0.750065,
      NULL,
      1,
      NULL,
      1,
      0.103358,
      NULL,
      0.515776,
      0.600223,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.458378,
      '04321',
      NULL,
      '',
      1.398591,
      '',
      '',
      '',
      1.260699,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


