set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '00244443',
      NULL,
      21.626842,
      NULL,
      48,
      4,
      NULL,
      NULL,
      '234304',
      2,
      ' 4- 4-1975',
      56,
      35.160575,
      0.758732,
      NULL,
      1.676732,
      0,
      0,
      1,
      0,
      1,
      1.611633,
      0,
      NULL,
      1,
      1.040160,
      1,
      1,
      0.676534,
      NULL,
      0,
      0,
      1,
      1,
      1.500038,
      0,
      NULL,
      0.838217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627477,
      1.523768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549263,
      0,
      3.592315,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1.634377,
      1.847303,
      0.139033,
      1,
      0.454150,
      1,
      NULL,
      NULL,
      NULL,
      0.906987,
      1,
      NULL,
      1.068915,
      0,
      2.669396,
      2.922700,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.502093,
      0,
      1.273991,
      5,
      3,
      3.857196,
      1,
      1,
      0,
      5.649937,
      2,
      0,
      3.194634,
      5,
      1,
      NULL,
      NULL,
      4.312022,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885088,
      1,
      1,
      NULL,
      0,
      NULL,
      0.012613,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857867,
      3.212628,
      1.299834,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.964837,
      8.396303,
      3.471632,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.020403,
      1.748641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.107641,
      1.835789,
      1,
      0,
      0,
      1.420879,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.071946,
      1.490906,
      NULL,
      0.426154,
      NULL,
      1.510805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '44103',
      NULL,
      NULL,
      1.770183,
      '',
      '',
      '',
      0.479640,
      '',
      '',
      '',
      4,
      2,
      1.232966,
      2.005175,
      3.351214,
      1,
      NULL,
      NULL,
      1);
commit;
end;
/


