set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '04102130',
      NULL,
      49.939573,
      NULL,
      NULL,
      4,
      0.123022,
      2,
      '324220',
      2.452409,
      ' 8- 4-1980',
      15.470190,
      23,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1.786604,
      0,
      0.449342,
      0,
      NULL,
      1,
      1,
      1.471859,
      2.356265,
      1.972084,
      0,
      0.224015,
      1,
      1.788522,
      1,
      1,
      1.273527,
      1,
      0,
      1,
      0.721376,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.170793,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.885173,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609056,
      1.760140,
      0,
      1.580931,
      1.647232,
      1,
      1.332683,
      0,
      0,
      0,
      1.560007,
      1,
      0.266317,
      NULL,
      0,
      0.259347,
      1,
      0,
      0.018281,
      NULL,
      NULL,
      1.301487,
      0.025570,
      3,
      NULL,
      0,
      4,
      1.004928,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.148589,
      NULL,
      1.656684,
      6.467512,
      7.519000,
      3.111432,
      3.590901,
      0.490645,
      NULL,
      1.230453,
      5.813112,
      NULL,
      NULL,
      0.989715,
      1.531436,
      NULL,
      NULL,
      0.775911,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.321984,
      2,
      NULL,
      NULL,
      1,
      0,
      0.444738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344175,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281287,
      3.098241,
      1.434637,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      0,
      0.014716,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443804,
      1.066016,
      NULL,
      1.060062,
      3.799777,
      0.774671,
      1.770766,
      NULL,
      0,
      1.083037,
      1.236890,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.827135,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '41440',
      NULL,
      '',
      1.336140,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      5,
      3,
      2,
      2,
      3.329528,
      0,
      1,
      0.792267,
      0);
commit;
end;
/


