set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '44121130',
      NULL,
      NULL,
      '2312203',
      275.788112,
      3,
      0,
      3,
      '312020',
      1,
      '11-16-1995',
      14,
      33.419547,
      1,
      NULL,
      0.300687,
      0,
      2,
      NULL,
      0.227733,
      NULL,
      1.551238,
      1,
      1.486803,
      1,
      NULL,
      1.047592,
      NULL,
      0,
      2,
      0.238513,
      2.481666,
      1.877315,
      NULL,
      0.353257,
      1,
      1.419021,
      2,
      1,
      NULL,
      0.988852,
      1.823334,
      1.936049,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.731693,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997396,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566870,
      1.599962,
      1,
      1,
      NULL,
      NULL,
      0,
      1.417434,
      NULL,
      NULL,
      1.082582,
      0,
      NULL,
      0.181770,
      NULL,
      NULL,
      0.923071,
      0.748896,
      1.486419,
      NULL,
      1,
      1,
      1.763021,
      4.791575,
      3.059074,
      0,
      0.205904,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578910,
      1.052128,
      NULL,
      4.513317,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.302058,
      1.639919,
      0,
      0,
      1.912625,
      NULL,
      NULL,
      6,
      1.763487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432409,
      0.437927,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.097313,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.906433,
      2.024718,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.218469,
      NULL,
      0.759599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348848,
      3,
      NULL,
      1,
      3,
      NULL,
      0.832168,
      0,
      1.333107,
      3.658596,
      0,
      1,
      1.216850,
      1,
      0.204646,
      1.519257,
      1.557359,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '13024',
      NULL,
      '',
      1.064176,
      '',
      NULL,
      '',
      0.498248,
      '',
      '',
      NULL,
      4.704072,
      3.103319,
      3,
      1,
      NULL,
      NULL,
      2.088289,
      2,
      3);
commit;
end;
/


