set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4301',
      '40121032',
      42.675374,
      17.898265,
      '4344133',
      57,
      3,
      2.943033,
      3,
      '203412',
      1,
      '10-29-1976',
      18.514562,
      43,
      NULL,
      NULL,
      0.587388,
      1.607905,
      NULL,
      0,
      1,
      1,
      0.848749,
      0.535655,
      1,
      1,
      3,
      NULL,
      0.242327,
      1,
      NULL,
      1.548111,
      5.465424,
      1,
      1,
      1.411116,
      1.061164,
      0,
      5,
      0,
      NULL,
      NULL,
      0.720929,
      0.594965,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.055631,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.193552,
      1.533893,
      3.658163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.858197,
      1.554895,
      0.025485,
      1,
      1,
      0.580186,
      NULL,
      1,
      NULL,
      1.666605,
      1,
      1.671886,
      1.686038,
      0.202921,
      1,
      0,
      0.153588,
      1,
      NULL,
      1.534543,
      4.389015,
      NULL,
      2.118464,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940284,
      5.439749,
      1,
      1,
      7.298649,
      NULL,
      6.577035,
      4.253719,
      0.528091,
      NULL,
      6,
      5,
      1,
      0,
      1,
      0.169247,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.964673,
      1,
      0,
      1,
      0.274696,
      1,
      1.121000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      0,
      3.840024,
      NULL,
      NULL,
      1.350202,
      0,
      2,
      5.733572,
      2.581126,
      0.722625,
      0.217565,
      NULL,
      NULL,
      NULL,
      1.434051,
      3.077006,
      7.802918,
      5.935336,
      1.074919,
      1,
      0.908646,
      NULL,
      NULL,
      NULL,
      NULL,
      2.185812,
      1.561381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.136548,
      0.778019,
      1.827646,
      NULL,
      0.065067,
      0,
      2,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1.241218,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.629217,
      '43130',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      4,
      3.749897,
      1.701481,
      1.136528,
      3,
      0.307000,
      3.150386,
      0.538533,
      1.745455);
commit;
end;
/


