set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4144',
      '44120403',
      15,
      56,
      NULL,
      342.301042,
      3,
      0.324066,
      NULL,
      '343403',
      5,
      ' 3-13-1975',
      14,
      56.375264,
      0.971670,
      NULL,
      1,
      1,
      0,
      1.596639,
      0,
      0,
      0,
      3,
      1.454439,
      0,
      1.404977,
      0.738195,
      3.858732,
      NULL,
      1.712704,
      0,
      2.754726,
      0,
      2,
      NULL,
      1.353952,
      NULL,
      4.728339,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868481,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.245877,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.363436,
      0.686254,
      0,
      0.256618,
      1.389292,
      0,
      0,
      NULL,
      0,
      0.403072,
      NULL,
      0.452494,
      NULL,
      NULL,
      0.901529,
      1.526173,
      0,
      NULL,
      0,
      1.438531,
      NULL,
      0.836681,
      1,
      0,
      2,
      2.752700,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.922582,
      0.309177,
      1.222076,
      0,
      7,
      3.266244,
      NULL,
      2,
      NULL,
      0.708668,
      5,
      NULL,
      NULL,
      1,
      NULL,
      1.823817,
      NULL,
      NULL,
      6.600705,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281389,
      0,
      0,
      0,
      NULL,
      1.657175,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.435555,
      0,
      NULL,
      1,
      1.294284,
      1.792682,
      1.561142,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577063,
      1.670347,
      1,
      3.320603,
      3.591539,
      0,
      0.346303,
      NULL,
      NULL,
      NULL,
      1,
      2.954633,
      0.472870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.806295,
      1.573645,
      1,
      NULL,
      0,
      1.433289,
      1.916009,
      NULL,
      1.974009,
      1,
      NULL,
      NULL,
      0.180535,
      1.912664,
      0,
      1,
      0.227615,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.796635,
      '04244',
      '',
      NULL,
      1.813071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0,
      1.384899,
      1.659969,
      NULL,
      2,
      NULL,
      1,
      3,
      NULL);
commit;
end;
/


