set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3411',
      '13341413',
      36.367384,
      NULL,
      NULL,
      244.662913,
      4,
      1,
      3,
      '004324',
      2.624419,
      ' 9-17-1981',
      18,
      20.268289,
      0,
      NULL,
      1,
      0.901249,
      2,
      0,
      0,
      NULL,
      1.920940,
      3.607658,
      NULL,
      NULL,
      2,
      0,
      4.686904,
      NULL,
      3.389567,
      0,
      NULL,
      0,
      0,
      1.992863,
      4.097400,
      0.163025,
      NULL,
      1,
      NULL,
      0.766621,
      2.796099,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939497,
      0.981879,
      4.412875,
      NULL,
      NULL,
      5.945822,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.892167,
      0.381748,
      0.725034,
      1.519739,
      0,
      1,
      1.256138,
      NULL,
      1,
      3.365792,
      2.087656,
      6.067469,
      0.929557,
      1.365265,
      5.682129,
      1.577838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062865,
      0,
      NULL,
      0,
      5,
      4.502780,
      0.102537,
      5,
      1,
      0,
      4,
      1.661739,
      0,
      NULL,
      0,
      1.122854,
      NULL,
      NULL,
      4.644872,
      0.088346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571463,
      0,
      0,
      NULL,
      1.434298,
      0,
      0.636369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584430,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869107,
      NULL,
      0.245047,
      5,
      1.231798,
      NULL,
      0.586142,
      NULL,
      NULL,
      NULL,
      NULL,
      3.781483,
      1.513588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850030,
      NULL,
      0.884631,
      1.410779,
      0.566107,
      0.704323,
      1.153105,
      0,
      1.294270,
      2,
      0.429144,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.522851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.439538,
      '03111',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      4.656650,
      NULL,
      NULL,
      1,
      NULL,
      3.520092,
      0.300724,
      3,
      NULL);
commit;
end;
/


