set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '10',
      39,
      6,
      '4414323',
      6,
      4,
      1.491097,
      2,
      '414030',
      5,
      NULL,
      109.281047,
      26.645695,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.133995,
      1,
      NULL,
      0,
      0.256797,
      NULL,
      1.540110,
      8.391564,
      1,
      1,
      1,
      0.683610,
      0,
      3.538267,
      1.768855,
      7.714572,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.729953,
      NULL,
      NULL,
      1.099844,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.692780,
      1,
      1.710240,
      3.754269,
      0.578327,
      1.778590,
      1.301991,
      2.842649,
      1,
      3.557283,
      0.590022,
      1,
      1,
      1.788634,
      NULL,
      1.599069,
      3,
      0.628061,
      NULL,
      0,
      2,
      NULL,
      0.646162,
      NULL,
      NULL,
      0.467507,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      3,
      NULL,
      1.200033,
      1.046146,
      0,
      4,
      NULL,
      1.684910,
      1,
      NULL,
      0.412575,
      1.277690,
      1,
      0,
      NULL,
      1,
      0,
      6.227090,
      5.321465,
      0,
      0,
      2,
      0,
      1.502375,
      NULL,
      1.127795,
      1.680468,
      0.848836,
      NULL,
      0,
      7,
      1,
      1,
      NULL,
      1.241708,
      1.294955,
      1.516590,
      2,
      NULL,
      NULL,
      0.744686,
      0,
      3,
      2.022028,
      1.718753,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.050268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.198814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.431699,
      1,
      1,
      2,
      0.864504,
      NULL,
      NULL,
      1.204742,
      4,
      1,
      4.836027,
      0,
      NULL,
      0.821786,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1.579376,
      2.312845,
      1,
      1.145334,
      0,
      1,
      1,
      0.960330,
      0.656448,
      0,
      1,
      NULL,
      0.973529,
      0,
      1.704917,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '11033',
      '',
      '',
      1.733040,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      2.410957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


