set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '422',
      '23',
      33.419909,
      8,
      '4442130',
      17.903247,
      NULL,
      2.805170,
      1,
      '121130',
      0,
      ' 5- 3-1997',
      9.650148,
      55.693928,
      0,
      NULL,
      NULL,
      1.471403,
      0.206873,
      0,
      0.780572,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      1.861788,
      1,
      2.501600,
      0.026152,
      NULL,
      1,
      0.404670,
      4.105855,
      3,
      NULL,
      1,
      2.476037,
      1,
      4.271767,
      3,
      2,
      1.485885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      1.646673,
      1,
      1,
      1.803270,
      0,
      1,
      2,
      2.382733,
      1.747790,
      2,
      0,
      3,
      1,
      1.118854,
      3,
      2.035263,
      0,
      NULL,
      2,
      0.176348,
      1,
      0,
      0.635098,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.474440,
      1,
      1.918591,
      1,
      7,
      NULL,
      1.005816,
      NULL,
      0,
      0,
      1.780753,
      NULL,
      3,
      1,
      1.391498,
      NULL,
      0.991168,
      1.804460,
      NULL,
      1,
      0.485679,
      3.482549,
      3,
      0.241482,
      0.589918,
      NULL,
      0.139397,
      1.836924,
      1.630590,
      1.295628,
      1,
      0.676793,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      4.271805,
      7,
      NULL,
      0.316520,
      6.387994,
      7.413288,
      1.028378,
      1,
      2,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      5,
      1.932181,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.105772,
      0.923608,
      NULL,
      7.452662,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.730352,
      1,
      0.377502,
      NULL,
      2.301841,
      1,
      0.383085,
      0,
      NULL,
      NULL,
      1.732706,
      NULL,
      1.899437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180986,
      3.139764,
      NULL,
      1,
      1,
      2.234519,
      1.818055,
      1.534261,
      1,
      0,
      1,
      0.585682,
      NULL,
      0,
      0.776248,
      NULL,
      1.692284,
      0.951100,
      1,
      0.467545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '12123',
      '',
      '',
      0.394649,
      '',
      '',
      NULL,
      0.457512,
      NULL,
      '',
      '',
      5.219036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


