set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '10',
      NULL,
      1.935504,
      '0301322',
      32,
      NULL,
      1.198204,
      3,
      '430031',
      NULL,
      ' 5-24-1978',
      NULL,
      35,
      1.597415,
      NULL,
      2,
      1,
      NULL,
      0.128434,
      1,
      NULL,
      0.394223,
      1,
      NULL,
      NULL,
      5.844553,
      NULL,
      0.066637,
      0.750527,
      0,
      1,
      5,
      0.008666,
      5,
      4,
      5.892009,
      0,
      0,
      NULL,
      NULL,
      2.986811,
      2.516155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.540758,
      NULL,
      1.040502,
      0.065978,
      1.782071,
      2,
      2,
      0.805652,
      1,
      3,
      0,
      1.722216,
      0,
      0.478488,
      2.632563,
      2,
      0,
      1.719431,
      0,
      9.153757,
      1,
      2,
      1,
      0.937432,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.985146,
      5.577489,
      1.458196,
      NULL,
      7,
      0,
      1.645481,
      1,
      1,
      2,
      4.448954,
      0.049139,
      5.861448,
      0.683428,
      0,
      NULL,
      0.124409,
      NULL,
      NULL,
      0.719502,
      0,
      NULL,
      4.932467,
      0.952754,
      1,
      0.329464,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.578972,
      NULL,
      0,
      3.946900,
      5,
      3,
      2.369416,
      1,
      5.645181,
      7,
      1.226355,
      7.335318,
      NULL,
      1.404133,
      1,
      NULL,
      2,
      1.673495,
      1,
      2.226790,
      0.436663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557688,
      NULL,
      0,
      NULL,
      NULL,
      5.781410,
      5.734150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.322120,
      2.005271,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      5.863914,
      NULL,
      0,
      1,
      NULL,
      0.629069,
      NULL,
      NULL,
      1,
      NULL,
      1.145774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.765035,
      3,
      0,
      0,
      0.450306,
      0,
      0.428972,
      0,
      1.650144,
      1,
      1,
      1,
      NULL,
      1,
      1.211483,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545093,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437942,
      0.638992,
      NULL,
      1.620432,
      0,
      NULL,
      2,
      0,
      '34030',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


