set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '11',
      8.657492,
      23,
      '0123434',
      NULL,
      NULL,
      3.101470,
      NULL,
      NULL,
      NULL,
      ' 3-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      0.911595,
      NULL,
      1.012859,
      1.987632,
      1,
      0,
      0,
      1.307339,
      0.691584,
      1.404843,
      3.770310,
      0.864422,
      0.795565,
      0.223479,
      2.057343,
      0.175307,
      7,
      0,
      3,
      NULL,
      4.674902,
      1.342700,
      0,
      0,
      2,
      0.574130,
      0,
      0,
      NULL,
      NULL,
      1.620444,
      NULL,
      NULL,
      2,
      6.638177,
      0.484651,
      2,
      1.963731,
      1,
      2,
      0,
      0.716252,
      NULL,
      2.720367,
      0,
      0.686852,
      1.622299,
      NULL,
      0,
      1,
      0,
      2.357570,
      NULL,
      0.123944,
      3.221833,
      1.429262,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.275285,
      1,
      2,
      1,
      0,
      7.111019,
      5.504781,
      0,
      0.178319,
      1,
      4,
      3,
      0.736478,
      3.082107,
      0.119847,
      1.480646,
      NULL,
      1,
      0.892043,
      NULL,
      0.184514,
      0.880977,
      3.313943,
      5.641659,
      1,
      0.846008,
      4,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0.786337,
      1.195537,
      1.480865,
      1,
      7,
      0,
      NULL,
      5.907464,
      0.114956,
      1.118341,
      4,
      NULL,
      1.443702,
      1.859693,
      3,
      NULL,
      0,
      0.057699,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      1.321311,
      2,
      5,
      1.381419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      NULL,
      NULL,
      1.249576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.020831,
      3.286284,
      1,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      3,
      0.573304,
      0,
      7,
      NULL,
      NULL,
      NULL,
      1.825246,
      10,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972253,
      NULL,
      NULL,
      3,
      0.689744,
      NULL,
      1.708801,
      1.288470,
      1,
      1.169596,
      2.544932,
      0,
      0,
      1.703247,
      0,
      1.609340,
      1,
      0,
      1.214433,
      1.705451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.038632,
      NULL,
      1.187583,
      0.933804,
      0,
      2,
      3,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      2.257580,
      NULL,
      2.446286,
      5,
      0,
      4,
      2.296874,
      3,
      0);
commit;
end;
/


